WinFly - Desktop Fly Animation
===============================

A fun Windows application that displays animated flies crawling across your screen.

## Features

- Realistic fly movement with random direction changes and pauses
- Configurable number of flies, timeout, size, and size variation
- GUI launcher for easy configuration
- CLI version for command-line usage

## Default Settings

Both CLI and GUI versions default to:

- **Number of flies**: 1
- **Timeout**: 15 seconds
- **Fly size**: 2.0x (36 pixels)
- **Size variation**: 0%

## GUI Controls

The GUI launcher provides sliders for:

- **Number of flies** (1-50) - How many flies to spawn
- **Timeout** (0-600 seconds) - Auto-close after timeout (0 = never)
- **Fly size** (0.5-3.0 in 0.1 increments) - Size multiplier (base 18px)
- **Size variation** (0-100%) - Per-fly size randomization

## Building

### Quick Build

Build the CLI only:

```powershell
g++ -std=c++17 winfly.cpp -o winfly.exe -mwindows -lgdiplus -lgdi32 -luser32 -lshell32 -lole32 -loleaut32 -luuid
```

Build the GUI:

```powershell
windres winfly_gui.rc -O coff -o winfly_gui.res
g++ -std=c++17 winfly_gui.cpp winfly_gui.res -o winfly_gui.exe -mwindows -lgdiplus -lgdi32 -luser32 -lshell32 -lole32 -loleaut32 -luuid -lcomctl32
```

### Required Files

**CLI (winfly.exe):**

- `winfly.cpp` - Main application
- `fly\fly.png` - Fly image (loaded from disk)

**GUI (winfly_gui.exe):**

- `winfly_gui.cpp` - GUI launcher
- `winfly_gui.rc` - Resource file
- `winfly_gui.exe.manifest` - Application manifest
- `fly.ico` - Application icon
- `fly\fly.png` - Fly image

The GUI launches the CLI (`winfly.exe`) as a subprocess with the configured parameters.

## Usage

### GUI Mode

1. Run `winfly_gui.exe`
2. Adjust sliders to desired settings
3. Click "Let's Fly" to launch

### CLI Mode

Run `winfly.exe` directly or with command-line arguments:

```bash
winfly.exe [options]

Options:
  -n, --count <num>       Number of flies (default: 1)
  -t, --timeout <secs>    Auto-close timeout in seconds (default: 15, 0 = never)
  -s, --size <size>       Fly size - values 1-5 are scale levels (1=18px, 2=36px, etc.)
                          or use explicit pixel values >5 (default: 36)
  -v, --variation <pct>   Size variation percentage 0-100 (default: 0)
  <num>                   Bare number sets fly count
```

**Examples:**

```bash
winfly.exe                           # 1 fly, 15 sec timeout, 36px size
winfly.exe -n 5 -t 30 -s 2.0        # 5 flies, 30 sec, 36px (2.0x multiplier)
winfly.exe -n 10 -s 50 -v 20        # 10 flies, 50px size with ±20% variation
winfly.exe 20                        # 20 flies with default settings
```

### Stopping

- Wait for the timeout to expire
- Close via Task Manager (`Ctrl+Shift+Esc`)
- Or use: `taskkill /F /IM winfly.exe`

## Technical Details

- Built with C++ and Win32 API
- Uses GDI+ for image rendering and transformations
- Transparent layered windows with per-pixel alpha
- Flies move across virtual screen (multi-monitor aware)
- Random behavior includes direction changes, speed variations, and pauses
