# build_all.ps1 - Build both WinFly CLI and GUI launcher
# Usage: .\build_all.ps1

$here = Split-Path -Path $MyInvocation.MyCommand.Definition -Parent
Push-Location $here

# Check for required files
if (-not (Test-Path .\fly\fly.png)) {
    Write-Error "Required file 'fly\fly.png' not found."
    Pop-Location
    exit 1
}

if (-not (Test-Path .\fly.ico)) {
    Write-Error "Required file 'fly.ico' not found."
    Pop-Location
    exit 1
}

Write-Output "=== Building WinFly CLI (winfly.exe) ==="
Write-Output "Building winfly.exe (using external fly\fly.png)..."
& g++ -std=c++17 winfly.cpp -o winfly.exe -mwindows -lgdiplus -lgdi32 -luser32 -lshell32 -lole32 -loleaut32 -luuid
if ($LASTEXITCODE -ne 0) {
    Write-Error "g++ build failed for winfly.exe"
    Pop-Location
    exit $LASTEXITCODE
}

Write-Output "`n=== Building WinFly GUI (winfly_gui.exe) ==="
Write-Output "Compiling GUI resources..."
windres winfly_gui.rc -O coff -o winfly_gui.res
if ($LASTEXITCODE -ne 0) {
    Write-Error "windres failed for winfly_gui.rc"
    Pop-Location
    exit $LASTEXITCODE
}

Write-Output "Building winfly_gui.exe..."
& g++ -std=c++17 winfly_gui.cpp winfly_gui.res -o winfly_gui.exe -mwindows -lgdiplus -lgdi32 -luser32 -lshell32 -lole32 -loleaut32 -luuid -lcomctl32
if ($LASTEXITCODE -ne 0) {
    Write-Error "g++ build failed for winfly_gui.exe"
    Pop-Location
    exit $LASTEXITCODE
}

Write-Output "`n=== Build Complete ==="
Write-Output "Built: $here\winfly.exe"
Write-Output "Built: $here\winfly_gui.exe"
Pop-Location
